from typing import Any, Dict, List

from mail.beagle.beagle.core.actions.base import BaseDBAction
from mail.beagle.beagle.core.entities.smtp_cache import SMTPCache
from mail.beagle.beagle.core.exceptions import MailListNotFoundError
from mail.beagle.beagle.storage.exceptions import SMTPCacheNotFound


class SupportAction(BaseDBAction):
    def __init__(self, list_uid: int):
        super().__init__()
        self.list_uid = list_uid

    async def handle(self) -> List[Dict[str, Any]]:
        try:
            smtp_cache: SMTPCache = await self.storage.smtp_cache.get_by_uid(self.list_uid)
        except SMTPCacheNotFound:
            raise MailListNotFoundError
        subscribers = [{'uid': subscr.uid, 'stype': 'inbox'} for subscr in smtp_cache.value.subscriptions]
        return subscribers
