from typing import List, Set, Tuple

from mail.beagle.beagle.core.actions.base import BaseDBAction
from mail.beagle.beagle.core.actions.user.create import CreateUserAction
from mail.beagle.beagle.core.actions.user.delete import DeleteUserAction
from mail.beagle.beagle.core.actions.user.update import UpdateUserAction
from mail.beagle.beagle.core.entities.external_organization import BaseExternalOrganization
from mail.beagle.beagle.core.entities.user import User


class SyncUsersAction(BaseDBAction):
    def __init__(self, org_id: int, external_organization: BaseExternalOrganization):
        super().__init__()
        self.org_id: int = org_id
        self.external_organization: BaseExternalOrganization = external_organization

    async def handle(self) -> Tuple[List[User], Set[int]]:
        external_users = {
            external_user.uid: external_user
            async for external_user in self.external_organization.get_users()
        }

        users = []
        affected_uids: Set[int] = set()

        async for user in self.storage.user.find(self.org_id):
            external_user = external_users.pop(user.uid, None)
            if external_user is None:
                affected_uids.update(await DeleteUserAction(user=user).run())
            else:
                user = await UpdateUserAction(user=user, user_entity=external_user).run()
                users.append(user)
        for external_user in external_users.values():
            user = await CreateUserAction(user_entity=external_user).run()
            users.append(user)

        return users, affected_uids
