from typing import Any, Dict

from mail.beagle.beagle.core.actions.base import BaseDBAction
from mail.beagle.beagle.core.exceptions import CoreInteractionFatalError


class TransactEmailAction(BaseDBAction):
    """Base asyncable action to trigger transactional mailing in sender"""
    action_name = 'transact_email_action'
    retry_exceptions = (CoreInteractionFatalError,)

    def __init__(self,
                 org_id: int,
                 to_email: str,
                 mailing_id: str,
                 render_context: Dict[str, Any],
                 ):
        super().__init__()
        self.org_id: int = org_id
        self.to_email: str = to_email
        self.mailing_id: str = mailing_id
        self.render_context: Dict[str, Any] = render_context

    async def handle(self) -> str:
        return await self.clients.sender.send_transactional_letter(
            mailing_id=self.mailing_id,
            to_email=self.to_email,
            render_context=self.render_context,
        )
