from typing import Set, Tuple

from mail.beagle.beagle.core.actions.base import BaseDBAction
from mail.beagle.beagle.core.actions.unit.create_auto_mail_list import CreateAutoMailListUnitAction
from mail.beagle.beagle.core.entities.unit import Unit


class CreateUnitAction(BaseDBAction):
    transact = True

    def __init__(self, unit_entity: Unit):
        super().__init__()
        self.unit_entity: Unit = unit_entity

    async def handle(self) -> Tuple[Unit, Set[int]]:
        affected_uids: Set[int] = set()
        unit = await self.storage.unit.create(self.unit_entity)
        if unit.uid is not None and unit.username is not None:
            affected_uids.add(unit.uid)
            await CreateAutoMailListUnitAction(unit).run()
        return unit, affected_uids
