from mail.beagle.beagle.core.actions.base import BaseDBAction
from mail.beagle.beagle.core.actions.mail_list.create import CreateMailListAction
from mail.beagle.beagle.core.entities.mail_list import MailList
from mail.beagle.beagle.core.entities.unit import Unit
from mail.beagle.beagle.core.entities.unit_subscription import UnitSubscription


class CreateAutoMailListUnitAction(BaseDBAction):
    def __init__(self, unit: Unit):
        super().__init__()
        self.unit: Unit = unit

    async def handle(self) -> MailList:
        assert self.unit.unit_id is not None \
            and self.unit.uid is not None \
            and self.unit.username is not None
        mail_list = await CreateMailListAction(
            org_id=self.unit.org_id,
            username=self.unit.username,
            uid=self.unit.uid,
            generate_cache=False,
        ).run()
        await self.storage.unit_subscription.create(UnitSubscription(
            org_id=self.unit.org_id,
            mail_list_id=mail_list.mail_list_id,
            unit_id=self.unit.unit_id,
        ))
        return mail_list
