from typing import Set

from mail.beagle.beagle.core.actions.base import BaseDBAction
from mail.beagle.beagle.core.actions.mail_list.delete import DeleteMailListAction
from mail.beagle.beagle.core.entities.mail_list import MailList
from mail.beagle.beagle.core.entities.unit import Unit


class DeleteUnitAction(BaseDBAction):
    """Deletes unit and it's mail list.
    """
    transact = True

    def __init__(self, unit: Unit):
        super().__init__()
        self.unit: Unit = unit

    async def handle(self) -> Set[int]:
        affected_uids = set()
        async for unit_subscription in self.storage.unit_subscription.find(
            org_id=self.unit.org_id,
            unit_id=self.unit.unit_id,
        ):
            assert isinstance(unit_subscription.mail_list, MailList)
            mail_list = unit_subscription.mail_list
            if mail_list.uid == self.unit.uid:
                await DeleteMailListAction(mail_list=mail_list).run()
            else:
                affected_uids.add(mail_list.uid)
        await self.storage.unit.delete(self.unit)
        return affected_uids
