from mail.beagle.beagle.core.actions.mail_list.base import BaseMailListAction
from mail.beagle.beagle.core.actions.smtp_cache import GenerateSMTPCacheAction
from mail.beagle.beagle.core.entities.enums import SubscriptionType
from mail.beagle.beagle.core.entities.unit_subscription import UnitSubscription
from mail.beagle.beagle.core.exceptions import UnitNotFoundError, UnitSubscriptionAlreadyExistsError
from mail.beagle.beagle.storage.exceptions import UnitNotFound, UnitSubscriptionAlreadyExists


class CreateUnitSubscriptionAction(BaseMailListAction):
    transact = True

    def __init__(self,
                 org_id: int,
                 mail_list_id: int,
                 unit_id: int,
                 subscription_type: SubscriptionType,
                 ):
        super().__init__(org_id=org_id, mail_list_id=mail_list_id)
        self.unit_id: int = unit_id
        self.subscription_type: SubscriptionType = subscription_type

    async def handle(self) -> UnitSubscription:
        assert self.mail_list_id and self.org_id

        unit_subscription_entity = UnitSubscription(org_id=self.org_id,
                                                    mail_list_id=self.mail_list_id,
                                                    unit_id=self.unit_id,
                                                    subscription_type=self.subscription_type)
        try:
            unit_subscription: UnitSubscription = await self.storage.unit_subscription.create(unit_subscription_entity)
        except UnitNotFound:
            raise UnitNotFoundError
        except UnitSubscriptionAlreadyExists:
            raise UnitSubscriptionAlreadyExistsError

        await GenerateSMTPCacheAction(org_id=self.org_id, mail_list_id=unit_subscription.mail_list_id).run_async()

        return unit_subscription
