from mail.beagle.beagle.core.actions.mail_list.base import BaseMailListAction
from mail.beagle.beagle.core.actions.smtp_cache import GenerateSMTPCacheAction
from mail.beagle.beagle.core.exceptions import UnitSubscriptionNotFoundError
from mail.beagle.beagle.storage.exceptions import UnitSubscriptionNotFound


class DeleteUnitSubscriptionAction(BaseMailListAction):
    transact = True

    def __init__(self, org_id: int, mail_list_id: int, unit_id: int):
        super().__init__(org_id=org_id, mail_list_id=mail_list_id)
        self.unit_id: int = unit_id

    async def handle(self) -> None:
        assert self.mail_list_id and self.org_id
        try:
            unit_subscription = await self.storage.unit_subscription.get(
                org_id=self.org_id,
                mail_list_id=self.mail_list_id,
                unit_id=self.unit_id,
                for_update=True
            )
        except UnitSubscriptionNotFound:
            raise UnitSubscriptionNotFoundError

        await self.storage.unit_subscription.delete(unit_subscription)
        await GenerateSMTPCacheAction(org_id=self.org_id, mail_list_id=self.mail_list_id).run_async()
