from typing import List, Optional

from sendr_utils import alist

from mail.beagle.beagle.core.actions.mail_list.base import BaseMailListAction
from mail.beagle.beagle.core.entities.unit_subscription import UnitSubscription


class GetUnitSubscriptionAction(BaseMailListAction):
    def __init__(self,
                 org_id: int,
                 mail_list_id: int,
                 unit_id: Optional[int] = None,
                 limit: Optional[int] = None,
                 offset: Optional[int] = None
                 ):
        super().__init__(org_id=org_id, mail_list_id=mail_list_id)
        self.unit_id: Optional[int] = unit_id
        self.limit: Optional[int] = limit
        self.offset: Optional[int] = offset

    async def handle(self) -> List[UnitSubscription]:
        assert self.org_id
        return await alist(self.storage.unit_subscription.find(org_id=self.org_id,
                                                               mail_list_id=self.mail_list_id,
                                                               unit_id=self.unit_id,
                                                               limit=self.limit,
                                                               offset=self.offset)
                           )
