from mail.beagle.beagle.core.actions.base import BaseDBAction
from mail.beagle.beagle.core.entities.user import User
from mail.beagle.beagle.core.exceptions import OrganizationNotFoundError
from mail.beagle.beagle.storage.exceptions import OrganizationNotFound


class CreateUserAction(BaseDBAction):
    transact = True

    def __init__(self, user_entity: User):
        super().__init__()
        self.user_entity: User = user_entity

    async def handle(self) -> User:
        try:
            user: User = await self.storage.user.create(self.user_entity)
        except OrganizationNotFound:
            raise OrganizationNotFoundError
        self.logger.context_push(uid=self.user_entity.uid)
        self.logger.debug('User created.')
        return user
