from typing import Set

from mail.beagle.beagle.core.actions.base import BaseDBAction
from mail.beagle.beagle.core.actions.user.get_dependent_uids import GetDependentUIDsUserAction
from mail.beagle.beagle.core.entities.user import User


class DeleteUserAction(BaseDBAction):
    def __init__(self, user: User):
        super().__init__()
        self.user: User = user

    async def handle(self) -> Set[int]:
        affected_uids = await GetDependentUIDsUserAction(self.user.org_id, self.user.uid).run()
        await self.storage.user.delete(self.user)
        self.logger.context_push(uid=self.user.uid)
        self.logger.debug('User deleted.')
        return affected_uids
