from mail.beagle.beagle.core.actions.base import BaseDBAction
from mail.beagle.beagle.core.exceptions import UserNotFoundError
from mail.beagle.beagle.storage.exceptions import UserNotFound


class GetUserAction(BaseDBAction):
    def __init__(self, org_id: int, uid: int):
        super().__init__()
        self.org_id: int = org_id
        self.uid: int = uid

    async def handle(self):
        try:
            return await self.storage.user.get(self.org_id, self.uid)
        except UserNotFound:
            raise UserNotFoundError
