from typing import Set

from mail.beagle.beagle.core.actions.base import BaseDBAction
from mail.beagle.beagle.core.entities.not_fetched import NotFetchedType


class GetDependentUIDsUserAction(BaseDBAction):
    """
    Returns set of uids of mail_lists which contain uid.
    """

    transact = True

    def __init__(self, org_id: int, uid: int):
        super().__init__()
        self.org_id: int = org_id
        self.uid: int = uid

    async def handle(self) -> Set[int]:
        mail_list_uids: Set[int] = set()

        # Mail lists from user subscriptions
        async for user_subscription in self.storage.user_subscription.find(org_id=self.org_id, uid=self.uid):
            assert not isinstance(user_subscription.mail_list, NotFetchedType)
            mail_list_uids.add(user_subscription.mail_list.uid)

        # Mail lists from unit subscriptions
        unit_ids = [
            unit_user.unit_id
            async for unit_user in self.storage.unit_user.find(org_id=self.org_id, uid=self.uid)
        ]
        async for unit_subscription in self.storage.unit_subscription.find(org_id=self.org_id, unit_ids=unit_ids):
            assert not isinstance(unit_subscription.mail_list, NotFetchedType)
            mail_list_uids.add(unit_subscription.mail_list.uid)

        return mail_list_uids
