from mail.beagle.beagle.core.actions.mail_list.base import BaseMailListAction
from mail.beagle.beagle.core.actions.smtp_cache import GenerateSMTPCacheAction
from mail.beagle.beagle.core.exceptions import UserSubscriptionNotFoundError
from mail.beagle.beagle.storage.exceptions import UserSubscriptionNotFound


class DeleteUserSubscriptionAction(BaseMailListAction):
    transact = True

    def __init__(self, org_id: int, mail_list_id: int, uid: int):
        super().__init__(org_id=org_id, mail_list_id=mail_list_id)
        self.uid: int = uid

    async def handle(self) -> None:
        assert self.org_id and self.mail_list_id
        try:
            user_subscription = await self.storage.user_subscription.get(org_id=self.org_id,
                                                                         mail_list_id=self.mail_list_id,
                                                                         uid=self.uid,
                                                                         for_update=True)
        except UserSubscriptionNotFound:
            raise UserSubscriptionNotFoundError
        await self.storage.user_subscription.delete(user_subscription)
        await GenerateSMTPCacheAction(org_id=self.org_id, mail_list_id=self.mail_list_id).run_async()
