from enum import Enum, unique

from sendr_taskqueue import BaseTaskType, BaseWorkerType


@unique
class OrganizationType(Enum):
    DIRECTORY = 'directory'


@unique
class MailListType(Enum):
    MANUAL = 'manual'
    AUTO = 'auto'


@unique
class SubscriptionType(Enum):
    INBOX = 'inbox'
    YORK = 'york'


@unique
class WorkerType(BaseWorkerType):
    RUN_ACTION = 'run_action'
    SYNC_ORGANIZATION = 'sync_organization'


@unique
class TaskType(BaseTaskType, Enum):
    RUN_ACTION = 'run_action'
    SYNC_ORGANIZATION = 'sync_organization'
