from abc import ABCMeta, abstractmethod
from typing import AsyncIterable, ClassVar, Dict, Set, Tuple, Type

from mail.beagle.beagle.core.entities.enums import OrganizationType
from mail.beagle.beagle.core.entities.unit import ExternalKeyType, Unit
from mail.beagle.beagle.core.entities.user import User


class BaseExternalOrganization(metaclass=ABCMeta):
    _external_organizations_by_type: Dict[OrganizationType, Type['BaseExternalOrganization']] = {}
    TYPE: ClassVar[OrganizationType]

    def __init_subclass__(cls) -> None:
        external_organization_type = getattr(cls, 'TYPE')
        assert external_organization_type not in BaseExternalOrganization._external_organizations_by_type
        BaseExternalOrganization._external_organizations_by_type[external_organization_type] = cls

    @abstractmethod
    async def get_revision(self) -> int:
        """Must return True if organization synchronization is not required."""
        pass

    @abstractmethod
    def get_units(self) -> AsyncIterable[Unit]:
        pass

    @abstractmethod
    def get_unit_units(self) -> AsyncIterable[Tuple[ExternalKeyType, Set[ExternalKeyType]]]:
        """Must yield tuples of parent unit and set of it's children keys."""
        pass

    @abstractmethod
    def get_users(self) -> AsyncIterable[User]:
        """Must yield users."""
        pass

    @abstractmethod
    def get_unit_users(self) -> AsyncIterable[Tuple[ExternalKeyType, Set[int]]]:
        """Must yield tuples of unit and set of it's user uids."""
        pass
