from dataclasses import dataclass, field
from datetime import datetime
from typing import Optional

from mail.beagle.beagle.core.entities.enums import MailListType


@dataclass
class MailListDescription:
    ru: Optional[str] = None
    en: Optional[str] = None

    def __str__(self):
        return self.ru or self.en or ''


@dataclass
class MailList:
    org_id: int
    mail_list_type: MailListType
    uid: int
    username: str
    mail_list_id: Optional[int] = None
    description: MailListDescription = field(default_factory=MailListDescription)
    is_deleted: bool = False
    settings: dict = field(default_factory=dict)
    created: Optional[datetime] = None
    updated: Optional[datetime] = None
