from dataclasses import dataclass, field
from datetime import datetime
from typing import List, Optional


@dataclass
class Recipient:
    email: str
    uid: int


@dataclass
class CacheResponse:
    subscriptions: List[Recipient]


@dataclass
class CacheSubscription:
    uid: int
    org_id: int
    local_part: str
    params: dict = field(default_factory=dict)  # https://st.yandex-team.ru/PDDMAIL-330#5e2580578ebc5e53810f094c


@dataclass
class CacheValue:
    subscriptions: List[CacheSubscription]


@dataclass
class SMTPCache:
    org_id: int
    uid: int
    value: CacheValue
    created: Optional[datetime] = None
    updated: Optional[datetime] = None
