from dataclasses import dataclass
from datetime import datetime
from typing import Optional, Tuple

ExternalKeyType = Tuple[str, str]


@dataclass
class Unit:
    org_id: int
    external_id: str
    external_type: str
    name: str
    unit_id: Optional[int] = None
    uid: Optional[int] = None
    username: Optional[str] = None
    created: Optional[datetime] = None
    updated: Optional[datetime] = None

    @staticmethod
    def get_external_key(external_type: str, external_id: str) -> ExternalKeyType:
        return (external_type, external_id)

    @property
    def external_key(self) -> ExternalKeyType:
        return self.get_external_key(self.external_type, self.external_id)
