from dataclasses import dataclass
from datetime import datetime
from typing import Optional, Union

from mail.beagle.beagle.core.entities.enums import SubscriptionType
from mail.beagle.beagle.core.entities.mail_list import MailList
from mail.beagle.beagle.core.entities.not_fetched import NOT_FETCHED, NotFetchedType


@dataclass
class UnitSubscription:
    org_id: int
    mail_list_id: int
    unit_id: int
    subscription_type: SubscriptionType = SubscriptionType.INBOX
    created: Optional[datetime] = None
    updated: Optional[datetime] = None

    mail_list: Union[NotFetchedType, MailList] = NOT_FETCHED
