from dataclasses import dataclass
from datetime import datetime
from typing import Optional, Union

from mail.beagle.beagle.core.entities.not_fetched import NOT_FETCHED, NotFetchedType
from mail.beagle.beagle.core.entities.unit import Unit


@dataclass
class UnitUnit:
    org_id: int
    unit_id: int
    parent_unit_id: int
    created: Optional[datetime] = None
    updated: Optional[datetime] = None

    # Generated
    unit: Union[Unit, NotFetchedType] = NOT_FETCHED
