from dataclasses import dataclass
from datetime import datetime
from typing import Optional, Union

from mail.beagle.beagle.core.entities.enums import SubscriptionType
from mail.beagle.beagle.core.entities.mail_list import MailList
from mail.beagle.beagle.core.entities.not_fetched import NOT_FETCHED, NotFetchedType


@dataclass
class UserSubscription:
    org_id: int
    mail_list_id: int
    uid: int
    subscription_type: SubscriptionType
    created: Optional[datetime] = None
    updated: Optional[datetime] = None

    mail_list: Union[NotFetchedType, MailList] = NOT_FETCHED
