from typing import Optional

from sendr_core.exceptions import BaseCoreError, CoreFailError  # noqa

from mail.beagle.beagle.utils.helpers import str_to_underscore


def get_error_message(cls):
    message = str_to_underscore(cls.__name__).lstrip('_').upper().lstrip('_')
    if message.endswith('_ERROR'):
        message = message[:-len('_ERROR')]
    cls.MESSAGE = message
    return message


class CoreSecurityError(BaseCoreError):
    pass


class CoreAccessDenyError(CoreSecurityError):
    pass


class CoreActionDenyError(CoreSecurityError):
    message = 'Action access denied'


class CoreNotFoundError(BaseCoreError):
    message = 'NOT_FOUND_ERROR'


class CoreDataError(BaseCoreError):
    MESSAGE: Optional[str] = None

    def __init__(self,
                 message: Optional[str] = None,
                 params: Optional[dict] = None,
                 ):
        self.message = message or self.MESSAGE
        self.params = params

    def __init_subclass__(cls) -> None:
        if cls.MESSAGE is None:
            cls.MESSAGE = get_error_message(cls)


class CoreAlreadyExists(CoreDataError):  # type: ignore
    def __init__(self, **kwargs):
        super().__init__(params=kwargs)

    def __init_subclass__(cls) -> None:
        cls.MESSAGE = get_error_message(cls)


class UserNotFoundError(CoreNotFoundError):
    message = 'USER_NOT_FOUND_ERROR'


class UserSubscriptionNotFoundError(CoreNotFoundError):
    message = 'USER_SUBSCRIPTION_NOT_FOUND_ERROR'


class UserSubscriptionAlreadyExistsError(CoreAlreadyExists):  # type: ignore
    pass


class CoreInteractionError(BaseCoreError):
    pass


class CoreInteractionFatalError(CoreInteractionError):
    pass


class OrganizationNotFoundError(CoreNotFoundError):
    message = 'ORGANIZATION_NOT_FOUND_ERROR'


class OrganizationAlreadyExistsError(CoreAlreadyExists):  # type: ignore
    pass


class MailListNotFoundError(CoreNotFoundError):
    message = 'MAIL_LIST_NOT_FOUND_ERROR'


class MailListAlreadyExistsError(CoreAlreadyExists):  # type: ignore
    pass


class MailListResponsibleNotFoundError(CoreNotFoundError):
    message = 'MAIL_LIST_RESPONSIBLE_NOT_FOUND_ERROR'


class MailListResponsibleAlreadyExistsError(CoreAlreadyExists):  # type: ignore
    pass


class UnitNotFoundError(CoreNotFoundError):
    message = 'UNIT_NOT_FOUND_ERROR'


class UnitSubscriptionAlreadyExistsError(CoreAlreadyExists):  # type: ignore
    pass


class UnitSubscriptionNotFoundError(CoreNotFoundError):
    message = 'UNIT_SUBSCRIPTION_NOT_FOUND_ERROR'


class UnitUpdateError(CoreFailError):
    message = 'UNIT_UPDATE_ERROR'


class UserUpdateError(CoreFailError):
    message = 'USER_UPDATE_ERROR'


# Interactions

class PassportError(CoreDataError):
    MESSAGE = 'PASSPORT_ERROR'


class DirectoryError(CoreDataError):
    MESSAGE = 'DIRECTORY_ERROR'


class DirectoryOrgNotFoundError(CoreNotFoundError):
    message = 'DIRECTORY_ORG_NOT_FOUND_ERROR'


class UserSubscriptionAlreadyExists(CoreAlreadyExists):  # type: ignore
    pass
