from sendr_interactions.exceptions import BaseInteractionError


class BaseBlackboxError(BaseInteractionError):
    def __init__(self, *, method=None, message=None, params=None):
        if params is not None:
            self.params = params
        super().__init__(service='blackbox', method=method, message=message)


class UnknownBlackBoxException(BaseBlackboxError):
    default_message = 'Unknown user exception'


class BlackBoxUserException(BaseBlackboxError):
    default_message = 'Blackbox user exception'


class BlackBoxUserNotFound(BaseBlackboxError):
    default_message = 'User not found'


class BlackBoxDefaultEmailNotFoundError(BaseBlackboxError):
    default_message = 'Default email not found'
