from dataclasses import dataclass
from enum import Enum, unique
from typing import List, Optional


@unique
class DirectoryObjectType(Enum):
    DEPARTMENT = 'department'
    GROUP = 'group'
    USER = 'user'


@dataclass
class DirectoryDepartment:
    department_id: int
    name: str
    label: str
    uid: Optional[int]
    parent_id: Optional[int]


@dataclass
class DirectoryGroup:
    group_id: int
    name: str
    label: str
    uid: Optional[int]


@dataclass
class DirectoryUser:
    user_id: int
    first_name: str
    last_name: str
    local_part: str
    departments: List[int]
    groups: List[int]
