from typing import ClassVar, Dict, Type

from sendr_interactions.exceptions import BaseInteractionError


class BasePassportError(BaseInteractionError):
    _exceptions_by_errors: ClassVar[Dict[str, Type['BasePassportError']]] = {}
    CODE: ClassVar[str]

    def __init__(self, *, method, message, params=None):
        if params is not None:
            self.params = params
        super().__init__(service='passport', method=method, message=message)

    def __init_subclass__(cls) -> None:
        code = getattr(cls, 'CODE', None)
        if code is not None:
            assert code not in BasePassportError._exceptions_by_errors
            BasePassportError._exceptions_by_errors[code] = cls

    @classmethod
    def get_exception_by_error(cls, code: str) -> Type['BasePassportError']:
        return cls._exceptions_by_errors.get(code, UnknownPassportError)


class UserAlreadyExistsError(BasePassportError):
    CODE = 'login.notavailable'
    default_message = 'USER_ALREADY_EXISTS'


class UnknownPassportError(BasePassportError):
    default_message = 'UNKNOWN_PASSPORT_ERROR'
