
from typing import Any

from aiohttp import web

from sendr_aiohttp import BaseUrlDispatcher
from sendr_qlog.http.aiohttp import get_middleware_logging_adapter, signal_request_id_header
from sendr_taskqueue.background import BackgroundSchedule

from mail.beagle.beagle.interactions.base import BaseInteractionClient, create_connector
from mail.beagle.beagle.mocks.directory.background import RecreateRandomOrganizationTask
from mail.beagle.beagle.mocks.directory.middlewares import middleware_response_formatter
from mail.beagle.beagle.mocks.directory.routes import ROUTES


class DirectoryMockApplication(web.Application):  # type: ignore
    background: BackgroundSchedule

    def __init__(self):
        super().__init__(
            router=BaseUrlDispatcher(),
            middlewares=(
                middleware_response_formatter,
                get_middleware_logging_adapter(),
            )
        )
        self.router.add_routes(ROUTES)

        self.background = BackgroundSchedule()
        self.background.add_task(RecreateRandomOrganizationTask(logger=self.logger))

        self.on_response_prepare.append(signal_request_id_header)

        self.on_startup.append(self.background.run)
        self.on_startup.append(self.create_connector)
        self.on_cleanup.append(self.background.stop)
        self.on_cleanup.append(self.close_connector)

    async def create_connector(self, _: Any) -> None:
        BaseInteractionClient.CONNECTOR = create_connector()

    async def close_connector(self, _: Any) -> None:
        await BaseInteractionClient.close_connector()
