import random
import uuid

from sendr_qlog import LoggerContext
from sendr_taskqueue.background import BackgroundTask

from mail.beagle.beagle.conf import settings
from mail.beagle.beagle.interactions.base import BaseInteractionClient
from mail.beagle.beagle.mocks.directory.data import ORGS, delete_org, get_org


class BeagleClient(BaseInteractionClient):
    BASE_URL = settings.MOCK_DIRECTORY_CALLBACK_URL.rstrip('/')
    SERVICE = 'beagle'

    async def sync(self, org_id: int) -> None:
        await self.post('sync', self.endpoint_url('api/v1/sync/org'), json={'org_id': org_id})


class RecreateRandomOrganizationTask(BackgroundTask):
    pause_period = settings.MOCK_RECREATE_INTERVAL

    def __init__(self, *args, **kwargs):
        super().__init__(*args, **kwargs)
        self.logger_context = LoggerContext(self.logger)
        self.beagle = BeagleClient(self.logger_context, uuid.uuid4().hex)

    async def _run(self) -> None:
        org_ids = list(ORGS.keys())

        if org_ids:
            org_id = random.choice(org_ids)

            org = await get_org(org_id)
            await delete_org(org_id)
            await get_org(org_id, init_revision=org['revision'] + 1)
            await self.beagle.sync(org_id)

            self.logger_context.context_push(org_id=org_id)
            self.logger_context.info('Organization was recreated')
