from typing import Awaitable, Callable

import ujson
from aiohttp import web

from mail.beagle.beagle.api.exceptions import APIException
from mail.beagle.beagle.api.handlers.base import BaseHandler
from mail.beagle.beagle.api.schemas.base import fail_response_schema

HandlerType = Callable[[web.Request], Awaitable[web.Response]]


@web.middleware
async def middleware_response_formatter(request: web.Request, handler: HandlerType) -> web.Response:
    try:
        response = await handler(request)
        if isinstance(response, (dict, list)):
            response = web.Response(body=ujson.dumps(response), content_type='application/json')
    except APIException as exc:
        response = BaseHandler.make_schema_response(
            data=exc,
            schema=fail_response_schema,
            status=exc.code,
        )
    return response
