from sendr_aiohttp import Url

from mail.beagle.beagle.api.handlers.utility import PingHandler
from mail.beagle.beagle.mocks.directory.handlers import (
    AmmoHandler, BlackboxMockHandler, DepartmentsHandler, DomainsHandler, GroupsHandler, GroupsMembersHandler,
    OrganizationsHandler, UsersHandler
)

ROUTES = (
    Url(r'/v11/departments/', DepartmentsHandler, name='v11_departments'),
    Url(r'/v11/groups/', GroupsHandler, name='v11_groups'),
    Url(r'/v11/organizations/{org_id:\w+}/', OrganizationsHandler, name='v11_organizations'),
    Url(r'/v11/domains/', DomainsHandler, name='v11_domains'),
    Url(r'/v11/groups/{group_id:\w+}/members/', GroupsMembersHandler, name='v11_groups_members'),
    Url(r'/v11/users/', UsersHandler, name='v11_users'),

    Url(r'/blackbox', BlackboxMockHandler, name='blackbox'),
    Url(r'/ping', PingHandler, name='ping'),
    Url(r'/ammo', AmmoHandler, name='ammo'),
)
