from sendr_aiopg import StorageAnnotatedMeta, StorageBase, StorageContextBase
from sendr_taskqueue.worker.storage import get_worker_mapper

from mail.beagle.beagle.core.entities.enums import WorkerType
from mail.beagle.beagle.storage.db.tables import metadata
from mail.beagle.beagle.storage.mappers.mail_list import MailListMapper
from mail.beagle.beagle.storage.mappers.mail_list_responsible import MailListResponsibleMapper
from mail.beagle.beagle.storage.mappers.organization import OrganizationMapper
from mail.beagle.beagle.storage.mappers.serial import SerialMapper
from mail.beagle.beagle.storage.mappers.smtp_cache import SMTPCacheMapper
from mail.beagle.beagle.storage.mappers.task import TaskMapper
from mail.beagle.beagle.storage.mappers.unit import UnitMapper
from mail.beagle.beagle.storage.mappers.unit_subscription import UnitSubscriptionMapper
from mail.beagle.beagle.storage.mappers.unit_unit import UnitUnitMapper
from mail.beagle.beagle.storage.mappers.unit_user import UnitUserMapper
from mail.beagle.beagle.storage.mappers.user import UserMapper
from mail.beagle.beagle.storage.mappers.user_subscription import UserSubscriptionMapper


class Storage(StorageBase, metaclass=StorageAnnotatedMeta):
    mail_list: MailListMapper
    mail_list_responsible: MailListResponsibleMapper
    organization: OrganizationMapper
    serial: SerialMapper
    smtp_cache: SMTPCacheMapper
    unit: UnitMapper
    unit_subscription: UnitSubscriptionMapper
    unit_unit: UnitUnitMapper
    unit_user: UnitUserMapper
    user: UserMapper
    user_subscription: UserSubscriptionMapper
    task: TaskMapper
    worker: get_worker_mapper(metadata, WorkerType)  # type: ignore


class StorageContext(StorageContextBase[Storage]):  # type: ignore
    STORAGE_CLS = Storage
