from sendr_aiopg.data_mapper import SelectableDataMapper, TableDataDumper
from sendr_aiopg.query_builder import CRUDQueries

from mail.beagle.beagle.core.entities.serial import Serial
from mail.beagle.beagle.storage.db.tables import serials as t_serials
from mail.beagle.beagle.storage.exceptions import SerialNotFound
from mail.beagle.beagle.storage.mappers.base import BaseMapper


class SerialDataMapper(SelectableDataMapper):
    entity_class = Serial
    selectable = t_serials


class SerialDataDumper(TableDataDumper):
    entity_class = Serial
    table = t_serials


class SerialMapper(BaseMapper):
    name = 'serial'
    _builder = CRUDQueries(
        base=t_serials,
        id_fields=('org_id',),
        mapper_cls=SerialDataMapper,
        dumper_cls=SerialDataDumper,
    )

    async def create(self, serial: Serial) -> Serial:
        query, mapper = self._builder.insert(serial)
        return mapper(await self._query_one(query))

    async def get(self, org_id: int) -> Serial:
        query, mapper = self._builder.select(id_values=(org_id,))
        return mapper(await self._query_one(query, raise_=SerialNotFound))

    async def save(self, serial: Serial) -> Serial:
        query, mapper = self._builder.update(serial)
        return mapper(await self._query_one(query, raise_=SerialNotFound))
