from sqlalchemy import update

from mail.beagle.beagle.storage.db.tables import serials as t_serials
from mail.beagle.beagle.storage.exceptions import SerialNotFound


class SerialMixin:
    async def _acquire_serial(self, org_id: int, column: str) -> int:
        query = (
            update(t_serials).
            where(t_serials.c.org_id == org_id).
            values(**{column: getattr(t_serials.c, column) + 1}).
            returning(*t_serials.c)
        )
        return (await self._query_one(query, raise_=SerialNotFound))[column] - 1  # type: ignore

    async def acquire_mail_list_id(self, org_id: int) -> int:
        return await self._acquire_serial(org_id, 'mail_list_id')

    async def acquire_unit_id(self, org_id: int) -> int:
        return await self._acquire_serial(org_id, 'unit_id')
