import re
from datetime import datetime, timezone
from typing import Iterable, TypeVar

_T = TypeVar('_T')
_camelcase_regex = re.compile('([A-Z])')


def str_to_underscore(s: str) -> str:
    return _camelcase_regex.sub(lambda match: '_' + match.group(1).lower(), s)


def without_none(d: dict) -> dict:
    return {
        k: (without_none(v) if isinstance(v, dict) else v)
        for k, v in d.items()
        if v is not None
    }


def update_from_fields(mutable_obj: _T, data_obj: _T, fields: Iterable[str]) -> bool:
    """Updates fields of mutable_obj with data from data_obj. Returns True if anything was modified."""
    changed = False
    for field in fields:
        old_value = getattr(mutable_obj, field)
        new_value = getattr(data_obj, field)
        if old_value != new_value:
            changed = True
            setattr(mutable_obj, field, new_value)
    return changed


def date_to_str(date_: datetime) -> str:
    return date_.astimezone(tz=timezone.utc).isoformat()
