OWNER(g:mail-swat)

PY3_LIBRARY()

PEERDIR(
    contrib/python/aiosocksy
    contrib/python/marshmallow-enum/py2
    contrib/python/ujson
    contrib/python/uvloop
    library/python/resource
    mail/python/sendr-qtools
)

PY_SRCS(
    __init__.py
    api/app.py
    api/exceptions.py
    api/handlers/base.py
    api/handlers/mail_list.py
    api/handlers/mail_list_responsible.py
    api/handlers/recipients.py
    api/handlers/support.py
    api/handlers/sync.py
    api/handlers/unit_subscription.py
    api/handlers/user.py
    api/handlers/user_subscription.py
    api/handlers/utility.py
    api/middlewares.py
    api/routes/__init__.py
    api/routes/base.py
    api/routes/mail_list.py
    api/routes/recipients.py
    api/routes/support.py
    api/routes/sync.py
    api/routes/user.py
    api/routes/utility.py
    api/schemas/base.py
    api/schemas/mail_list.py
    api/schemas/mail_list_responsible.py
    api/schemas/path.py
    api/schemas/recipients.py
    api/schemas/support.py
    api/schemas/sync.py
    api/schemas/unit_subscription.py
    api/schemas/user.py
    api/schemas/user_subscription.py
    commands/__init__.py
    commands/create_organization.py
    commands/pg_pinger_env.py
    commands/runmock.py
    commands/runserver.py
    commands/runworkers.py
    commands/sync_organization.py
    commands/update_caches.py
    conf.py
    core/actions/__init__.py
    core/actions/base.py
    core/actions/mail_list/__init__.py
    core/actions/mail_list/base.py
    core/actions/mail_list/create.py
    core/actions/mail_list/delete.py
    core/actions/mail_list/get.py
    core/actions/mail_list/get_list.py
    core/actions/mail_list/update.py
    core/actions/mail_list_responsible/__init__.py
    core/actions/mail_list_responsible/create.py
    core/actions/mail_list_responsible/delete.py
    core/actions/mail_list_responsible/get.py
    core/actions/organization.py
    core/actions/ping_db.py
    core/actions/recipients.py
    core/actions/smtp_cache.py
    core/actions/support.py
    core/actions/sync/sync_organization.py
    core/actions/sync/sync_unit_members.py
    core/actions/sync/sync_units.py
    core/actions/sync/sync_users.py
    core/actions/transact_email.py
    core/actions/unit/create.py
    core/actions/unit/create_auto_mail_list.py
    core/actions/unit/delete.py
    core/actions/unit/get_dependent_uids.py
    core/actions/unit/update.py
    core/actions/unit_subscription/__init__.py
    core/actions/unit_subscription/create.py
    core/actions/unit_subscription/delete.py
    core/actions/unit_subscription/get.py
    core/actions/user/create.py
    core/actions/user/delete.py
    core/actions/user/get.py
    core/actions/user/get_dependent_uids.py
    core/actions/user/update.py
    core/actions/user_subscription/__init__.py
    core/actions/user_subscription/create.py
    core/actions/user_subscription/delete.py
    core/actions/user_subscription/get.py
    core/context.py
    core/entities/directory_organization.py
    core/entities/enums.py
    core/entities/external_organization.py
    core/entities/mail_list.py
    core/entities/mail_list_responsible.py
    core/entities/not_fetched.py
    core/entities/organization.py
    core/entities/serial.py
    core/entities/smtp_cache.py
    core/entities/task.py
    core/entities/unit.py
    core/entities/unit_subscription.py
    core/entities/unit_unit.py
    core/entities/unit_user.py
    core/entities/user.py
    core/entities/user_subscription.py
    core/exceptions.py
    interactions/__init__.py
    interactions/base.py
    interactions/blackbox/__init__.py
    interactions/blackbox/entities.py
    interactions/blackbox/exceptions.py
    interactions/directory/__init__.py
    interactions/directory/entities.py
    interactions/directory/exceptions.py
    interactions/hound/__init__.py
    interactions/hound/entities.py
    interactions/mbody/__init__.py
    interactions/mbody/exceptions.py
    interactions/passport/__init__.py
    interactions/passport/exceptions.py
    interactions/sender/__init__.py
    manage.py
    mocks/__init__.py
    mocks/directory/__init__.py
    mocks/directory/app.py
    mocks/directory/background.py
    mocks/directory/data.py
    mocks/directory/handlers.py
    mocks/directory/middlewares.py
    mocks/directory/routes.py
    mocks/utils.py
    storage/__init__.py
    storage/db/tables.py
    storage/exceptions.py
    storage/mappers/base.py
    storage/mappers/mail_list.py
    storage/mappers/mail_list_responsible.py
    storage/mappers/organization.py
    storage/mappers/serial.py
    storage/mappers/serial_mixin.py
    storage/mappers/smtp_cache.py
    storage/mappers/task.py
    storage/mappers/unit.py
    storage/mappers/unit_subscription.py
    storage/mappers/unit_unit.py
    storage/mappers/unit_user.py
    storage/mappers/user.py
    storage/mappers/user_subscription.py
    taskq/__init__.py
    taskq/app.py
    utils/cli.py
    utils/db.py
    utils/graph.py
    utils/helpers.py
    utils/logging.py
    utils/stats.py
    utils/tvm.py
)

RESOURCE_FILES(
    settings/000-logging.conf
    settings/000-logging.conf.production
    settings/010-common.conf
    settings/010-common.conf.production
    settings/020-database.conf
    settings/020-database.conf.development
    settings/030-interactions.conf
    settings/030-interactions.conf.production
    settings/040-tvm.conf
    settings/040-tvm.conf.development
    settings/050-taskq.conf
    settings/060-mock.conf
)

END()

RECURSE_FOR_TESTS(tests)
