#!/usr/bin/env bash
set -e
. /usr/lib/qloud-mail-common.sh

if [ -z "$ENVIRONMENT_TYPE" ]; then
  echo 'ENVIRONMENT_TYPE is not set'
  exit 1
fi

if [ -z "$APPLICATION_NAME" ]; then
  echo 'APPLICATION_NAME is not set'
  exit 1
fi

check_ephemeral && qloud_log nginx

ln -sf /etc/nginx/sites-available/unistat.conf /etc/nginx/sites-enabled/unistat.conf
ln -sf /etc/nginx/sites-available/app/$ENVIRONMENT_TYPE.conf /etc/nginx/sites-enabled/app-$ENVIRONMENT_TYPE.conf

ln -sf /etc/supervisor/conf-available/nginx.conf /etc/supervisor/conf.d/nginx.conf
ln -sf /etc/supervisor/conf-available/pg-pinger.conf /etc/supervisor/conf.d/pg-pinger.conf
ln -sf /etc/supervisor/conf-available/app/$APPLICATION_NAME.conf /etc/supervisor/conf.d/$APPLICATION_NAME.conf

mkdir -p /var/run/juggler-client/
chown monitor /var/run/juggler-client/

exec "$@"
