CREATE TABLE beagle.organizations (
    org_id BIGINT PRIMARY KEY,
    revision BIGINT DEFAULT 0,
    created TIMESTAMPTZ DEFAULT NOW(),
    updated TIMESTAMPTZ DEFAULT NOW()
);

CREATE TABLE beagle.serials (
    org_id BIGINT PRIMARY KEY,
    mail_list_id BIGINT DEFAULT 1,
    unit_id BIGINT DEFAULT 1,
    FOREIGN KEY (org_id) REFERENCES beagle.organizations (org_id)
);

ALTER TABLE beagle.organizations
ADD CONSTRAINT fk_organizations_on_serials FOREIGN KEY (org_id)
    REFERENCES beagle.serials (org_id)
    DEFERRABLE INITIALLY DEFERRED
;


CREATE TYPE beagle.mail_list_type AS ENUM ('manual', 'auto');

CREATE TABLE beagle.mail_lists (
    org_id BIGINT,
    mail_list_id BIGINT,
    mail_list_type beagle.mail_list_type,
    uid BIGINT,
    username TEXT,
    description JSONB,
    is_deleted BOOLEAN DEFAULT FALSE,
    settings JSONB,
    created TIMESTAMPTZ DEFAULT NOW(),
    updated TIMESTAMPTZ DEFAULT NOW(),
    PRIMARY KEY (org_id, mail_list_id),
    CONSTRAINT fk_mail_lists_org_id_on_organizations_org_id FOREIGN KEY (org_id) REFERENCES beagle.organizations ON DELETE RESTRICT
);
CREATE UNIQUE INDEX idx_mail_lists_uid ON beagle.mail_lists (uid) WHERE (is_deleted = FALSE);

CREATE TABLE beagle.users (
    org_id BIGINT,
    uid BIGINT,
    username TEXT,
    first_name TEXT,
    last_name TEXT,
    created TIMESTAMPTZ DEFAULT NOW(),
    updated TIMESTAMPTZ DEFAULT NOW(),
    PRIMARY KEY (org_id, uid),
    CONSTRAINT fk_users_on_organizations_org_id FOREIGN KEY (org_id) REFERENCES beagle.organizations ON DELETE RESTRICT
);

CREATE TABLE beagle.units (
    org_id BIGINT,
    unit_id BIGINT,
    uid BIGINT DEFAULT NULL,
    username TEXT,
    external_id TEXT,
    external_type TEXT,
    name TEXT,
    created TIMESTAMPTZ DEFAULT NOW(),
    updated TIMESTAMPTZ DEFAULT NOW(),
    PRIMARY KEY (org_id, unit_id),
    FOREIGN KEY (org_id) REFERENCES beagle.organizations ON DELETE RESTRICT
);

CREATE TABLE beagle.unit_units (
    org_id BIGINT,
    unit_id BIGINT,
    parent_unit_id BIGINT,
    created TIMESTAMPTZ DEFAULT NOW(),
    updated TIMESTAMPTZ DEFAULT NOW(),
    PRIMARY KEY (org_id, unit_id, parent_unit_id),
    FOREIGN KEY (org_id) REFERENCES beagle.organizations ON DELETE RESTRICT,
    FOREIGN KEY (org_id, unit_id) REFERENCES beagle.units ON DELETE CASCADE,
    FOREIGN KEY (org_id, parent_unit_id) REFERENCES beagle.units (org_id, unit_id) ON DELETE CASCADE
);

CREATE TABLE beagle.unit_users (
    org_id BIGINT,
    unit_id BIGINT,
    uid BIGINT,
    created TIMESTAMPTZ DEFAULT NOW(),
    updated TIMESTAMPTZ DEFAULT NOW(),
    PRIMARY KEY (org_id, unit_id, uid),
    FOREIGN KEY (org_id) REFERENCES beagle.organizations ON DELETE RESTRICT,
    FOREIGN KEY (org_id, unit_id) REFERENCES beagle.units ON DELETE CASCADE,
    FOREIGN KEY (org_id, uid) REFERENCES beagle.users ON DELETE CASCADE
);

CREATE TYPE beagle.subscription_type AS ENUM ('inbox', 'york');

CREATE TABLE beagle.unit_subscriptions (
    org_id BIGINT,
    mail_list_id BIGINT,
    unit_id BIGINT,
    subscription_type beagle.subscription_type,
    created TIMESTAMPTZ DEFAULT NOW(),
    updated TIMESTAMPTZ DEFAULT NOW(),
    PRIMARY KEY (org_id, mail_list_id, unit_id),
    FOREIGN KEY (org_id) REFERENCES beagle.organizations ON DELETE RESTRICT,
    FOREIGN KEY (org_id, mail_list_id) REFERENCES beagle.mail_lists ON DELETE CASCADE,
    FOREIGN KEY (org_id, unit_id) REFERENCES beagle.units ON DELETE CASCADE
);

CREATE TABLE beagle.user_subscriptions (
    org_id BIGINT,
    mail_list_id BIGINT,
    uid BIGINT,
    subscription_type beagle.subscription_type,
    created TIMESTAMPTZ DEFAULT NOW(),
    updated TIMESTAMPTZ DEFAULT NOW(),
    PRIMARY KEY (org_id, mail_list_id, uid),
    FOREIGN KEY (org_id) REFERENCES beagle.organizations ON DELETE RESTRICT,
    FOREIGN KEY (org_id, mail_list_id) REFERENCES beagle.mail_lists ON DELETE CASCADE,
    FOREIGN KEY (org_id, uid) REFERENCES beagle.users ON DELETE CASCADE
);


CREATE TABLE beagle.smtp_caches (
    org_id BIGINT,
    uid BIGINT,
    value JSONB,
    created TIMESTAMPTZ DEFAULT NOW(),
    updated TIMESTAMPTZ DEFAULT NOW(),
    PRIMARY KEY (org_id, uid),
    FOREIGN KEY (org_id) REFERENCES beagle.organizations ON DELETE RESTRICT
);

CREATE UNIQUE INDEX idx_smtp_caches_uid ON beagle.smtp_caches (uid);


CREATE TABLE beagle.mail_list_responsibles (
    org_id BIGINT,
    mail_list_id BIGINT,
    uid BIGINT,
    created TIMESTAMPTZ DEFAULT NOW(),
    updated TIMESTAMPTZ DEFAULT NOW(),
    PRIMARY KEY (org_id, mail_list_id, uid),
    FOREIGN KEY (org_id) REFERENCES beagle.organizations ON DELETE RESTRICT,
    FOREIGN KEY (org_id, mail_list_id) REFERENCES beagle.mail_lists ON DELETE CASCADE,
    FOREIGN KEY (org_id, uid) REFERENCES beagle.users ON DELETE CASCADE
);
