CREATE TYPE beagle.task_state as enum ('failed', 'pending', 'processing', 'finished', 'deleted', 'cleanup');
CREATE TYPE beagle.worker_state as enum ('running', 'shutdown', 'failed', 'cleanedup');
CREATE TYPE beagle.task_type as enum ('run_action', 'sync_organization');
CREATE TYPE beagle.worker_type as enum ('run_action', 'sync_organization');

CREATE TABLE beagle.tasks
(
    task_id     BIGSERIAL                              NOT NULL
        CONSTRAINT tasks_pkey PRIMARY KEY,
    task_type   beagle.task_type                       NOT NULL,
    state       beagle.task_state                      NOT NULL,
    action_name TEXT,
    org_id      BIGINT                   DEFAULT NULL,
    params      JSONB,
    details     JSONB,
    retries     INTEGER                  DEFAULT 0     NOT NULL,
    run_at      TIMESTAMP WITH TIME ZONE DEFAULT NOW() NOT NULL,
    created     TIMESTAMP WITH TIME ZONE DEFAULT NOW() NOT NULL,
    updated     TIMESTAMP WITH TIME ZONE DEFAULT NOW() NOT NULL,
    FOREIGN KEY (org_id) REFERENCES beagle.organizations (org_id)
);

CREATE INDEX i_tasks_by_state_type_run_at ON beagle.tasks (state, task_type, run_at, task_id);
CREATE INDEX i_tasks_org_id_task_type_state ON beagle.tasks (org_id, task_type, state);

CREATE TABLE beagle.workers
(
    worker_id   TEXT                NOT NULL
        CONSTRAINT workers_pkey PRIMARY KEY,
    worker_type beagle.worker_type  NOT NULL,
    host        TEXT                NOT NULL,
    state       beagle.worker_state NOT NULL,
    heartbeat   TIMESTAMP WITH TIME ZONE,
    startup     TIMESTAMP WITH TIME ZONE,
    task_id     BIGINT
        CONSTRAINT workers_task_id_fkey REFERENCES beagle.tasks

);