#!/bin/bash

for i in {1..10}; do
    if [[ -d /ephemeral ]]; then
        mkdir -p /ephemeral/logs/
        rm -rf /app/logs
        ln -sf /ephemeral/logs /app/logs

        break
    else
        echo "Ephemeral not found, sleeping"
        sleep 5
    fi
done


if [[ "${ENVIRONMENT_TYPE}" ]]; then
    if [[ "${ENVIRONMENT_NAME}" ]]; then
        export ENVIRONMENT="${ENVIRONMENT_NAME}-${ENVIRONMENT_TYPE}"
        echo "$ENVIRONMENT_NAME" > /etc/yandex/environment.name
    else
        export ENVIRONMENT="${ENVIRONMENT_TYPE}"
        echo "$ENVIRONMENT_TYPE" > /etc/yandex/environment.type
    fi
else
    echo "ENVIRONMENT_TYPE not set, cannot start"
    exit 1
fi


ln -sf /app/etc/aqua.xml-${ENVIRONMENT} /app/etc/aqua.xml
chmod 644 /app/cron/*
ln -s /app/cron/* /etc/cron.d/
ln -s /app/supervisor/* /etc/supervisor/conf.d/
