import os
from dataclasses import dataclass
from typing import List

import yaml


@dataclass
class LaunchAquaPackConfig:
    tries: int
    path_to_aqua: List[str]
    additional_arguments: List[str]
    wait_time: int


@dataclass
class Config:
    launch: LaunchAquaPackConfig
    log: str
    level: str
    port: int


_instance = None


def instance() -> Config:
    global _instance
    return _instance


def get_environment():
    return os.getenv('ENVIRONMENT_TYPE', 'missing')


def load_config(path: str) -> Config:
    global _instance
    with open(path) as f:
        _instance = Config(**yaml.safe_load(f)['config'])
        _instance.launch = LaunchAquaPackConfig(**_instance.launch)

    return _instance
