import datetime
import unicodedata
from time import mktime

CONTROL_CATEGORIES = {'Cc', 'Cf', 'Cs', 'Co', 'Cn'}
TSKV_ESCAPE_CHARS = {
    u'\t': u'\\t',
    u'\n': u'\\n',
    u'\r': u'\\r',
    u'\\': u'\\\\',
    chr(0): u'\\0',
}


def _escape_str_value(text):
    escaped_chars = []
    for char in text:
        if char in TSKV_ESCAPE_CHARS:
            escaped_chars.append(TSKV_ESCAPE_CHARS[char])
        elif unicodedata.category(char) in CONTROL_CATEGORIES:
            escaped_chars.append(str(char.encode('unicode_escape')))
        else:
            escaped_chars.append(char)
    return ''.join(escaped_chars)


def _escape_datetime(value):
    return str(int(mktime(value.timetuple())))


ESCAPE_PLAN = {
    str: _escape_str_value,
    int: str,
    float: str,
    datetime: _escape_datetime,
    None.__class__: lambda value: ''
}


def _default_escaper(value):
    return _escape_str_value(str(value))


def escape_value(value):
    esaper = ESCAPE_PLAN.get(value.__class__, _default_escaper)
    return esaper(value)


def format(values):
    return '\t'.join(
        ['tskv'] +
        ['{0}={1}'.format(key, escape_value(value)) for key, value in values]
    )
