import logging
from argparse import ArgumentParser

import aiohttp
import yaml
from aiohttp import web


def extract_port(path):
    with open(path) as f:
        return yaml.full_load(f)['config']['port']


def main():
    async def ping(_: web.Request) -> web.Response:
        try:
            async with aiohttp.ClientSession() as session:
                async with session.get(f'http://localhost:{borador_port}/ping') as borador_resp:
                    async with session.get(f'http://localhost:{unistat_port}/ping') as unistat_resp:
                        if borador_resp.status == 200 and 'pong' in await borador_resp.text():
                            if unistat_resp.status == 200 and 'pong' in await unistat_resp.text():
                                return web.Response(text='pong\n', status=200)
        except:
            pass

        return web.Response(text='fail\n', status=500)

    parser = ArgumentParser()
    parser.add_argument('--port', help='http port')
    parser.add_argument('--borador', help='borador config')
    parser.add_argument('--unistat', help='unistat config')

    args = parser.parse_args()

    borador_port = extract_port(args.borador)
    unistat_port = extract_port(args.unistat)

    app = web.Application()
    logging.basicConfig(level=logging.DEBUG)
    app.router.add_get('/ping', ping)
    web.run_app(app, host='::', port=args.port)


if __name__ == '__main__':
    main()
