from cpython cimport *
from libcpp.vector cimport vector

from mail.unistat.cpp.cython.meters cimport *
from mail.unistat.cpp.cython.logs cimport TskvLog
cimport mail.unistat.cpp.cython.run_cpp


cdef extern from "mail/borador/unistat/cpp/logs.h" namespace "unistat":
    cdef cppclass Logs:
        Logs(...)


def run(host, port, pyLogs, yplatformLogPath, logLevel):
    cdef vector[Logs] cppLogs
    for l in pyLogs:
        if isinstance(l, TskvLog):
            cppLogs.push_back(
                Logs((<TskvLog>l).__impl)
            )
        else:
            raise AttributeError("Unknown log type")

    mail.unistat.cpp.cython.run_cpp.run(host, port, cppLogs, yplatformLogPath, logLevel)
