import sqlite3
from sqlite3 import OperationalError
import logging

error_log = logging.getLogger('Error')
service_log = logging.getLogger('Service')


def db_operation_wrapper(fn):
    def wrapper(*args, **kwargs):
        try:
            return fn(*args, **kwargs)
        except OperationalError as e:
            error_log.error("DB Operation error: {}".format(str(e)))
        except Exception as e:
            error_log.error("DB unknown error: {}".format(str(e)))

    return wrapper


class DB(object):
    def __init__(self, db_name):
        self._conn = sqlite3.connect(db_name)

    @db_operation_wrapper
    def create_sb_monitoring_users_table(self):
        c = self._conn.cursor()
        c.execute('''CREATE TABLE sb_monitoring_users
         (tg_login text PRIMARY KEY, chat_id integer)''')
        self._conn.commit()

    @db_operation_wrapper
    def create_deploy_users_table(self):
        c = self._conn.cursor()
        c.execute('''CREATE TABLE deploy_monitoring_users
         (tg_login text PRIMARY KEY, chat_id integer, projects text)''')
        self._conn.commit()

    @db_operation_wrapper
    def add_user_to_sb_tasks_monitoring(self, tg_login, chat_id):
        c = self._conn.cursor()
        c.execute("INSERT INTO sb_monitoring_users VALUES (?,?)", (tg_login, chat_id,))
        self._conn.commit()

    @db_operation_wrapper
    def remove_user_from_sb_tasks_monitoring(self, tg_login):
        c = self._conn.cursor()
        c.execute("DELETE FROM sb_monitoring_users WHERE tg_login=?", (tg_login,))
        self._conn.commit()

    @db_operation_wrapper
    def get_user_sb_tasks_monitoring(self, tg_login):
        c = self._conn.cursor()
        c.execute('SELECT * FROM sb_monitoring_users WHERE tg_login=?', (tg_login,))
        result = c.fetchone()
        return result

    @db_operation_wrapper
    def get_all_users_sb_tasks_monitoring(self):
        c = self._conn.cursor()
        c.execute('SELECT * FROM sb_monitoring_users')
        result = c.fetchall()
        return result

    @db_operation_wrapper
    def add_user_to_deploy_monitoring(self, tg_login, chat_id, projects):
        c = self._conn.cursor()
        c.execute("INSERT INTO deploy_monitoring_users VALUES (?,?,?)", (tg_login, chat_id, projects,))
        self._conn.commit()

    @db_operation_wrapper
    def remove_user_from_deploy_monitoring(self, tg_login):
        c = self._conn.cursor()
        c.execute("DELETE FROM deploy_monitoring_users WHERE tg_login=?", (tg_login,))
        self._conn.commit()

    @db_operation_wrapper
    def get_user_deploy_monitoring(self, tg_login):
        c = self._conn.cursor()
        c.execute('SELECT * FROM deploy_monitoring_users WHERE tg_login=?', (tg_login,))
        result = c.fetchone()
        return result

    @db_operation_wrapper
    def get_all_users_deploy_monitoring(self):
        c = self._conn.cursor()
        c.execute('SELECT * FROM deploy_monitoring_users')
        result = c.fetchall()
        return result
