import yaml
import logging
from collections import namedtuple

ShingerPrintInfo = namedtuple('ShingerPrintInfo', 'host, port')
DetempleInfo = namedtuple('DetempleInfo', 'host, port')
TemplateIdentifierInfo = namedtuple('TemplateIdentifierInfo', 'host, port')
MbodyInfo = namedtuple('MbodyInfo', 'prestable_host, prestable_port, intranet_prestable_host, intranet_prestable_port')


def init_settings(conf_path):
    global conf
    global telegram_oauth_token
    global sandbox_oauth_token
    global staff_oauth_token
    global shinger_print_info
    global detemple_info
    global mbody_info
    global template_identifier_info
    global staff_auth_groups

    error_logger = logging.getLogger('Error')
    service_logger = logging.getLogger('Service')

    with open(conf_path, 'r') as f:
        conf = yaml.load(f.read())

    formatter = logging.Formatter('%(asctime)s %(levelname)s: %(message)s')

    error_handler = logging.handlers.WatchedFileHandler(conf['Daemon']['error_log'], mode='a',
                                                        encoding=None, delay=False)
    error_handler.setFormatter(formatter)
    error_logger.addHandler(error_handler)
    error_logger.setLevel(logging.ERROR)
    error_logger.propagate = False

    service_handler = logging.handlers.WatchedFileHandler(conf['Daemon']['service_log'], mode='a',
                                                          encoding=None, delay=False)
    service_handler.setFormatter(formatter)
    service_logger.addHandler(service_handler)
    service_logger.setLevel(logging.DEBUG)
    service_logger.propagate = False

    # Set loggers for tornado application
    tornado_handler = logging.handlers.WatchedFileHandler(conf['Daemon']['tornado_log'], mode='a',
                                                          encoding=None, delay=False)
    app_log = logging.getLogger("tornado.application")
    app_log.addHandler(tornado_handler)
    access_log = logging.getLogger("tornado.access")
    access_log.addHandler(tornado_handler)
    gen_log = logging.getLogger("tornado.general")
    gen_log.addHandler(tornado_handler)

    staff_auth_groups = conf["Authorization"]['groups']
    shinger_print_info = ShingerPrintInfo(conf['ShingerPrint']['host'], conf['ShingerPrint']['port'])
    detemple_info = DetempleInfo(conf['Detemple']['host'], conf['Detemple']['port'])
    template_identifier_info = TemplateIdentifierInfo(conf['TemplateIdentifier']['host'], conf['TemplateIdentifier']['port'])
    mbody_info = MbodyInfo(conf['MBody']['prestable_host'], conf['MBody']['prestable_port'],
                           conf['MBody']['intranet_prestable_host'], conf['MBody']['intranet_prestable_port'])

    with open(conf['Daemon']['telegram_token_path'], 'r') as f:
        telegram_oauth_token = f.read().strip()
    with open(conf['Daemon']['sandbox_token_path'], 'r') as f:
        sandbox_oauth_token = f.read().strip()
    with open(conf['Daemon']['staff_token_path'], 'r') as f:
        staff_oauth_token = f.read().strip()
