# -*- coding: utf-8 -*-
import logging
from tornado import gen
from async_http_client import AsyncHttpClient
import json

error_log = logging.getLogger('Error')
service_log = logging.getLogger('Service')


class TelegramApi(object):
    def __init__(self, queue, token):
        self._api_url = 'https://api.telegram.org/bot{token}'.format(token=token)
        self._http_client = AsyncHttpClient(self._api_url, request_timeout=3)
        self._last_update_id = 0
        self._q = queue

    @gen.coroutine
    def _get_updates(self):
        response = yield self._http_client.get('getUpdates', {'offset': self._last_update_id})
        body = json.loads(response.body)
        if body['ok'] and len(body['result']):
            for res in body['result']:
                self._last_update_id = max(self._last_update_id, res['update_id'] + 1)
                yield self._q.put(res)

    @gen.coroutine
    def send_message(self, chat_id, text):
        params = {'chat_id': chat_id, 'text': text}
        yield self._http_client.get('sendMessage', params)

    @gen.coroutine
    def update_worker(self):
        while True:
            nxt = gen.sleep(2)
            try:
                yield self._get_updates()
            except Exception as e:
                error_log.error("Updating error: {}".format(str(e)))
            finally:
                yield nxt
