from collections import namedtuple

Message = namedtuple('Message', 'message_id, From, date, chat, text, entities, photo')
Message.__new__.__defaults__ = (None,) * len(Message._fields)
User = namedtuple('User', 'Id, is_bot, first_name, last_name, username')
User.__new__.__defaults__ = (None,) * len(User._fields)
Chat = namedtuple('Chat', 'Id, Type, title, first_name, last_name, invite_link')
Chat.__new__.__defaults__ = (None,) * len(Chat._fields)
MessageEntity = namedtuple('MessageEntity', 'Type, offset, length, url, user')
MessageEntity.__new__.__defaults__ = (None,) * len(MessageEntity._fields)
BotCommand = namedtuple('BotCommand', 'name, handler, description')
AuthorizationRecord = namedtuple('AuthorizationRecord', 'tg_login, name')
AuthorizationRecord.__new__.__defaults__ = (None,) * len(AuthorizationRecord._fields)

qloud_statuses = ['ALLOCATING', 'PENDING_DEACTIVATE', 'CONFIGURING', 'PREPARING', 'DEPLOYED', 'REMOVING', 'REMOVED']

wait = ['WAIT_RES', 'WAIT_TASK', 'WAIT_TIME']
queue = ['ENQUEUEING', 'ENQUEUED']
br = ['NO_RES', 'STOPPING', 'EXCEPTION', 'TIMEOUT', 'STOPPED']
finish = ['SUCCESS', 'RELEASING', 'NOT_RELEASED', 'FAILURE', 'DELETING', 'DELETED']
execute = ['PREPARING', 'ASSIGNED', 'EXECUTING', 'TEMPORARY', 'FINISHING', 'SUSPENDING', 'SUSPENDED']
paused = ['TEMPORARY', 'SUSPENDING', 'SUSPENDED']
all_statuses = paused + execute + queue + wait + finish + br
active_st = paused + execute + queue + wait
active_st.append('STOPPING')
finish_st = finish + br
finish_st.remove('STOPPING')
