import logging
from tornado import gen
import datetime
import base64
import quopri
import re

error_log = logging.getLogger('Error')
service_log = logging.getLogger('Service')


def cached_decorator(fn):
    cache = {}

    @gen.coroutine
    def wrapper(*args, **kwargs):
        tg_login = args[1]
        service_log.debug("Authorization cache: {}".format(str(cache)))
        if tg_login in cache:
            if datetime.datetime.now() - cache[tg_login][1] < datetime.timedelta(hours=24):
                service_log.debug("Telegram Login found in cache {}".format(str(cache[tg_login])))
                raise gen.Return(cache[tg_login][0])
            else:
                service_log.debug("Telegram Login retention time expired {}".format(str(cache[tg_login])))
                del cache[tg_login]
        auth = yield fn(*args, **kwargs)
        cache[tg_login] = [auth, datetime.datetime.now()]
        raise gen.Return(auth)

    return wrapper


def decode_part(text, encoding):
    if encoding == "quoted-printable":
        return quopri.decodestring(text)
    elif encoding == "base64":
        return base64.b64decode(text)
    else:
        return text


def get_text_part(msg):
    """
    :type msg: email.message.Message
    :return: email.message.Message
    """
    plain = None
    for part in msg.walk():
        if part.get_content_type() == 'text/html':
            return part
        if part.get_content_type() == 'text/plain':
            plain = part
    return plain


def extract_text_after_bot_command(command, message):
    pattern = re.compile(r'^{}[ ]+(?P<text>.*)$'.format(command), re.DOTALL)
    arr = pattern.findall(message.text.encode('utf8'))
    if len(arr) == 1:
        return arr[0]
    else:
        return ''


class BotException(Exception):
    def __init__(self, msg, *args, **kwargs):
        self.__msg = msg
        super(Exception, self).__init__(self, *args, **kwargs)

    def __str__(self):
        return self.__msg
