CREATE OR REPLACE FUNCTION code.save_otp(
    i_uid text,
    i_email text,
    i_chat_id text,
    i_bot_id text,
    i_bot_platform text,
    i_otp_value text,
    i_extra jsonb
) RETURNS void AS $$
    INSERT INTO botdb.otps
    VALUES (i_uid, i_email, i_chat_id, i_bot_id, i_bot_platform, i_otp_value, i_extra)
    ON CONFLICT (chat_id, bot_id, bot_platform) DO UPDATE
        SET
            uid = i_uid,
            email = i_email,
            otp_value = i_otp_value,
            extra = i_extra,
            creation_ts = current_timestamp;
$$ LANGUAGE SQL;
