CREATE OR REPLACE FUNCTION code.verify_otp(
    i_chat_id text,
    i_bot_id text,
    i_bot_platform text,
    i_otp_value text,
    i_ttl_sec bigint
) RETURNS code.mail_account AS $$
DECLARE
    res code.mail_account;
BEGIN
    SELECT uid, email INTO res FROM botdb.otps WHERE
        chat_id = i_chat_id AND
        bot_id = i_bot_id AND
        bot_platform = i_bot_platform AND
        otp_value = i_otp_value AND
        creation_ts >= (current_timestamp - make_interval(secs => i_ttl_sec));

    DELETE FROM botdb.otps WHERE
        chat_id = i_chat_id AND
        bot_id = i_bot_id AND
        bot_platform = i_bot_platform;

    RETURN res;
END;
$$ LANGUAGE plpgsql;
